
Google Fonts Greek Glyphs Sets
============================

## Structure and Hierarchy of Glyph Sets for Greek:

#### General Use

1. **Core** Basic Monotonic set for everyday Modern Greek
2. **Plus** Basic Polytonic set for Scholarly Greek
3. **Expert** Small Caps for Core and Plus sets, Superscript Letters

#### Scholarly Use

1. **Pro** Extended Polytonic set for Ancient Greek Studies
2. **Archaic** Variable Letterforms for Ancient Texts, Papyri
3. **Ancient Musical Symbols** Greek and Byzantine Musical Symbols
4. **Coptic** Liturgical language for Coptic Church  

## General Use

### 1. GF Greek Core, 77 glyphs total 

> +43 Optional Small Cap Glyphs

Basic Monotonic Greek

* Basic Greek UC ` ΆΈΉΊΌΎΏΐΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩΪΫ `
* Basic Greek LC ` άέήίΰαβγδεζηθικλμνξοπρςστυφχψωϊϋόύώ `
* Punctuation ` · ; `
* Greek numeral signs or keraia ` ʹ ͵ `
* Accents `  ́ ΅ `
* Kai symbol ` ϗ Ϗ `

### 2. GF Greek Plus, 265 glyphs total 

> +185 Optional Small Cap Glyphs

Basic Polytonic Greek

**[Learn how to draw good Polytonic Greek at irenevl.github.io/Polytonic-tutorial](https://irenevl.github.io/Polytonic-tutorial/)**

* Polytonic UC `ἈἉἊἋἌἍἎἏἘἙἚἛἜἝἨἩἪἫἬἭἮἯἸἹἺἻἼἽἾἿὈὉὊὋὌὍὙὛὝὟὨὩὪὫὬὭὮὯᾈᾉᾊᾋᾌᾍᾎᾏᾘᾙᾚᾛᾜᾝᾞᾟᾨᾩᾪᾫᾬᾭᾮᾯᾸᾹᾺΆᾼῈΈῊΉῌῘῙῚΊῨῩῪΎῬῸΌῺΏῼ `
* Polytonic LC ` ἀἁἂἃἄἅἆἇἐἑἒἓἔἕἠἡἢἣἤἥἦἧἰἱἲἳἴἵἶἷὀὁὂὃὄὅὐὑὒὓὔὕὖὗὠὡὢὣὤὥὦὧὰάὲέὴήὶίὸόὺύὼώᾀᾁᾂᾃᾄᾅᾆᾇᾐᾑᾒᾓᾔᾕᾖᾗᾠᾡᾢᾣᾤᾥᾦᾧᾰᾱᾲᾳᾴᾶᾷιῂῃῄῆῇῐῑῒΐῖῗῠῡῢΰῤῥῦῧῲῳῴῶῷ `
* Accents ```   ́ ` ῀ `  ```
* Breathings ` ῾ ᾿ `
* Combinations ` ῁ ῍ ῎ ῏ ῝ ῞ ῟  ̈́ `
* Diactritics `  ͅ ι `
* Punctuation ` ᾽ `
* Combining Marks `  ̓ ΅  ͂ ͅ `
* Iota Adscript as ss01 `ᾈᾉᾊᾋᾌᾍᾎᾏᾘᾙᾚᾛᾜᾝᾞᾟᾨᾩᾪᾫᾬᾭᾮᾯᾼῌῼ`

### 3. GF Greek Expert, 283 glyphs total

Small Caps for Core and Plus sets, Superscript Letters

* Core .sc `άέήίΰαβγδεζηθικλμνξοπρςστυφχψωϊϋόύώ`
* Plus .sc `ἀἁἂἃἄἅἆἇἐἑἒἓἔἕἠἡἢἣἤἥἦἧἰἱἲἳἴἵἶἷὀὁὂὃὄὅὐὑὒὓὔὕὖὗὠὡὢὣὤὥὦὧὰάὲέὴήὶίὸόὺύὼώᾀᾁᾂᾃᾄᾅᾆᾇᾐᾑᾒᾓᾔᾕᾖᾗᾠᾡᾢᾣᾤᾥᾦᾧᾰᾱᾲᾳᾴᾶᾷιῂῃῄῆῇῐῑῒΐῖῗῠῡῢΰῤῥῦῧῲῳῴῶῷ Ϗ`
* Archaic Numerals .sc `ϛ ϟ ϡ ϝ`
* Iota Adscript as ss01 .sc `ᾈᾉᾊᾋᾌᾍᾎᾏᾘᾙᾚᾛᾜᾝᾞᾟᾨᾩᾪᾫᾬᾭᾮᾯᾼῌῼ`
* Superior Letters .sups `ΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩαβγδεζηθικλμνξοπρςστυφχψω`
* Ligatures `λλ γγ`

## Scholarly Use

### 4. GF Greek Pro, 82 glyphs total 

Extended Polytonic Greek, for scholarly edition of ancient texts (Ancient and Roman Greece studies, Byzantine studies, Greek Biblical studies)

**[Learn how to draw good Polytonic Greek at irenevl.github.io/Polytonic-tutorial](https://irenevl.github.io/Polytonic-tutorial/)**

**N.B.** List of characters from GF Latin Plus and Pro sets that are prerequisites to this set.

№ | char | nice name (Glyphs App) | uni name | set
---|---|---|---|---
1|²|twosuperior|uni00B2|GF Latin Plus
2|³|threesuperior|uni00B3|GF Latin Plus
3|¹|onesuperior|uni00B9|GF Latin Plus
4|⁰|zerosuperior|uni0270|GF Latin Pro
5|†|dagger|uni2020|GF Latin Plus
6|‡|daggerdbl|uni2021|GF Latin Plus
7|⁴|foursuperior|uni2074|GF Latin Plus
8|⁵|fivesuperior|uni2075|GF Latin Pro
9|⁶|sixsuperior|uni2076|GF Latin Pro
10|⁷|sevensuperior|uni2077|GF Latin Pro
11|⁸|eightsuperior|uni2078|GF Latin Pro
12|⁹|ninesuperior|uni2079|GF Latin Pro
13|₀|zeroinferior|uni2080|GF Latin Pro
14|₁|oneinferior|uni2081|GF Latin Pro
15|₂|twoinferior|uni2082|GF Latin Pro
16|₃|threeinferior|uni2083|GF Latin Pro
17|₄|fourinferior|uni2084|GF Latin Pro
18|₅|fiveinferior|uni2085|GF Latin Pro
19|₆|sixinferior|uni2086|GF Latin Pro
20|₇|seveninferior|uni2087|GF Latin Pro
21|₈|eightinferior|uni2088|GF Latin Pro
22|₉|nineinferior|uni2089|GF Latin Pro


* Archaic Letters and Numerals `Ϛ Ϟ Ϡ Ϝ ϛ ϟ ϡ ϝ`
* Ancient Greek Textual symbols `⸎ ⸏ ⸐ ⸑ ⸒ ⸓ ⸔ ⸕ ⸖ ⸗`
* Archaic Punctuation `※ ⁂ ‿ ͜ ˙ ⁖ ⁘ ⁙ ⁚ ⁛ ⁜ ⁝ ⁞ ⊗ ⋮`
* Greek Metrical Symbols `⏑ ⏒ ⏓ ⏔ ⏕ ⏖ ⏗ ⏘ ⏙`
* Critical Sigla `̅ ̣ ͙ ‖ ⁺ ⁻ ⁼ ₊ ₋ ₌ ⫽ ⸀ ⸁ ⸂ ⸃ ⸄ ⸅ ⸆ ⸇ ⸈ ⸉ ⸊ ⸋ ⸌ ⸍ 〈 〉《 》「 」〚 〛`
* Biblical Apparatus `ℵ ℶ 𝑙 𝔖 𝔐 𝔓 𝔭`


**N.B.** For certain design cases it is best practice to include inital and final variants of ` ̅` overlinecomb (uni0305):

* `overlinecomb.init`, cropped on the left
* `overlinecomb.fina`, cropped on the right

### 5. GF Greek Archaic, 143 glyphs total

Archaic, Papyri

* Archaic UC `ϘϚϜϞϠϺ`
* Archaic LC `ϙϛϝϟϡϻ`
* Variant Letterforms `κρςΣ`, `Θϐϑϒϓϔϕϖε϶`
* Additional Letter `ϳ`
* Additional Archaic Letters for Bactrian `Ϸϸ`
* Symbols `ϼ ☧`
* Editorial Symbols `ϽϾϿ`
* Ancient Greek Mathematical Character `⟀ ⟁`
* Ancient Greek Acrophonic Numerals `𐅀𐅁𐅂𐅃𐅆𐅇𐅈𐅉𐅊𐅋𐅌𐅍𐅎𐅏𐅐𐅑𐅒𐅓𐅔𐅕𐅖𐅗𐅘𐅙𐅚𐅛𐅜𐅝𐅞𐅟𐅠𐅡𐅢𐅣𐅤𐅥𐅦𐅧𐅨𐅩𐅪𐅫𐅬𐅭𐅮𐅯𐅰𐅱𐅲𐅳𐅴`
* Geometric shape `□`
* Astrological symbols `★☉☊☋☌☍☽☾☿♀♁♂♃♄♅♆♇♈♉♊♋♌♍♎♏♐♑♒♓`
 
### 6. GF Ancient Musical Symbols, 316 glyphs total

* Greek Vocal Notation Symbols
* Greek Instrumental Notation Symbols
* Byzantine Musical Symbols

### 7. GF Coptic, 137 glyphs total

Coptic `U+03E2` – `U+03EF`, Coptic Unicode block `U+2C80` – `U+2CFF`

* Coptic Letters `ϢϣϤϥϦϧϨϩϪϫϬϭϮϯ`
* Bohairic Coptic UC ` ⲀⲂⲄⲆⲈⲊⲌⲎⲐⲒⲔⲖⲘⲚⲜⲞⲠⲢⲤⲦⲨⲪⲬⲮⲰ`
* Bohairic Coptic LC ` ⲁⲃⲅⲇⲉⲋⲍⲏⲑⲓⲕⲗⲙⲛⲝⲟⲡⲣⲥⲧⲩⲫⲭⲯⲱ `
* Old Coptic and Dialect Letters UC` ⲲⲴⲶⲸⲺⲼⲾⳀⳂⳄⳆⳈⳊⳌⳎⳐⳒⳔⳖⳘⳚ`
* Old Coptic and Dialect Letters LC ` ⲳⲵⲷⲹⲻⲽⲿⳁⳃⳅⳇⳉⳋⳍⳏⳑⳓⳕⳗⳙⳛ `
* Old Nubian Letters ` ⳜⳞⳠⳢⳝⳟⳡⳣ `
* Symbols ` ⳤ⳥⳦⳧⳨⳩⳪ `
* Cryptogrammic Letters ` ⳫⳬⳭⳮ⳯⳰⳱ `
* Combining Marks ` ⳯⳰⳱ ` 
* Bohairic Coptic Letters ` Ⳳⳳ `
* Old Nubian Punctuation ` ⳹⳺⳻⳼ `
* Coptic Fraction ` ⳽ ` 
* Punctuation ` ⳾ ⳿ ` 

### Acknowledgements:

GF Greek Glyph Sets defined by Irene Vlachou @irenevl and Thomas Linard @thlinard.
Documented by Alexei Vanyashin @alexeiva January 2017.
